<?php

namespace App\Models\Events;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Events extends Model 
{

    protected $table = 'events';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('age0', 'public_registration', 'address');

    public function getRealizations()
    {
        return $this->hasMany('EventRealization');
    }

    public function getInstitution()
    {
        return $this->belongsTo('Institution');
    }

    public function getUser()
    {
        return $this->belongsTo('User');
    }

    public function getAccreditation()
    {
        return $this->hasOne('Accreditation');
    }

    public function getScopeRating()
    {
        return $this->belongsTo('ScopeRating');
    }

    public function getKeywords()
    {
        return $this->belongsToMany('Keyword', 'action_facts_keyword');
    }

    public function getEpisodeType()
    {
        return $this->belongsTo('EpisodeType');
    }

    public function getInvolvements()
    {
        return $this->belongsToMany('InvolvementsTypes', 'event_facts_involvement');
    }

    public function getQuiz()
    {
        return $this->hasOne('Events');
    }

}